const express = require('express');
const cors = require('cors');
const mongoose = require('mongoose');
const cookieParser = require('cookie-parser');
const fileUpload = require('express-fileupload');
const path = require('path');
const { PORT, DB_URI, CLIENT_ORIGIN } = require('./config/config');

const authRoutes = require('./routes/auth');
const userRoutes = require('./routes/user');
const asramaRoutes = require('./routes/asrama');
const meetingRoutes = require('./routes/ruangrapat');
const kendaraanRoutes = require('./routes/kendaraan');

const app = express();

app.use(cors({
    origin: 'http://localhost:5173',
    methods: ['POST', 'GET', 'PUT', 'DELETE', 'PATCH'],
    credentials: true
}));

app.use(express.json());
app.use(cookieParser());
app.use(fileUpload());

app.use('/images', express.static(path.join(__dirname, 'public/images')));

mongoose.connect(DB_URI, { useNewUrlParser: true, useUnifiedTopology: true })
    .then(() => console.log('Connected to MongoDB'))
    .catch(err => console.error('Failed to connect to MongoDB', err));

app.use('/auth', authRoutes);
app.use('/user', userRoutes);
app.use('/asrama', asramaRoutes);
app.use('/meeting', meetingRoutes);
app.use('/kendaraan', kendaraanRoutes);


app.listen(PORT, () => console.log(`Server is running on port ${PORT}`));
