const mongoose = require('mongoose');


const AsramaBookingSchema = new mongoose.Schema({
    user_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },
    //asumsi jurusan pelatihan
    borrower: {
        type: String,
        required: true
    },
    borrowDate: {
        type: Date,
        required: true
    },
    returnedDate: {
        type: Date,
        required: true
    },
    notes: {
        type: String,
        default: ''
    },
    asrama: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Asrama',
        required: true
    },
    status: {
        type: String,
        enum: ["menunggu", "disetujui", "ditolak", "selesai"],
        default: "menunggu"
    },
    ketersediaan: {
        type: String,
        enum: ["Tersedia", "Tidak Tersedia"],
        default: "Tersedia"
    }
}, { timestamps: true });


const AsramaSchema = new mongoose.Schema({
    name: {
        type: String,
        unique: true,
        required: true
    },
    photo: {
        type: String,
        required: true
    },
    url: {
        type: String,
        required: true
    },
    capacity: {
        type: Number,
        required: true
    }
}, { timestamps: true });

const AsramaBookingModel = mongoose.model('Booking', AsramaBookingSchema);
const AsramaModel = mongoose.model('Asrama', AsramaSchema);

module.exports = { AsramaBookingModel, AsramaModel };
