const mongoose = require('mongoose');

const KendaraanBookingSchema = new mongoose.Schema({
    user_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },
    borrower: {
        type: String,
        required: true
    },
    borrowDate: {
        type: Date,
        required: true
    },
    returnDate: {
        type: Date,
        required: true
    },
    keperluan: {
        type: String,
        required: true
    },
    notes: {
        type: String,
        default: ''
    },
    kendaraan: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Kendaraan',
        required: true
    },
    status: {
        type: String,
        enum: ["menunggu", "disetujui", "ditolak", "selesai"],
        default: "menunggu"
    },
    ketersediaan: {
        type: String,
        enum: ["Tersedia", "Tidak Tersedia"],
        default: "Tersedia"
    }
}, { timestamps: true });

const KendaraanSchema = new mongoose.Schema({
    photo: {
        type: String,
        required: true
    },
    url: {
        type: String,
        required: true
    },
    nopolisi: {
        type: String,
        unique: true,
        required: true
    },
    name:{
        type: String,
        unique: true,
        required: true
    },
    norangka:{
        type: String,
        unique: true,
        required: true
    },
    nomesin:{
        type: String,
        unique: true,
        required: true
    },
    nobpkb:{
        type: String,
        unique: true,
        required: true
    }
}, { timestamps: true });

const KendaraanBookingModel = mongoose.model('KendaraanBooking', KendaraanBookingSchema);
const KendaraanModel = mongoose.model('Kendaraan', KendaraanSchema);

module.exports = { KendaraanBookingModel, KendaraanModel };
