const mongoose = require('mongoose');

const MeetingBookingSchema = new mongoose.Schema({
    user_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },
    borrower: {
        type: String,
        required: true
    },
    borrowDate: {
        type: Date,
        required: true
    },
    startTime: {
        type: Date,
        required: true
    },
    endTime: {
        type: Date,
        required: true
    },
    notes: {
        type: String,
        default: ''
    },
    meetingRoom: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'MeetingRoom',
        required: true
    },
    status: {
        type: String,
        enum: ["menunggu", "disetujui", "ditolak", "selesai"],
        default: "menunggu"
    },
    ketersediaan: {
        type: String,
        enum: ["Tersedia", "Tidak Tersedia"],
        default: "Tersedia"
    }
}, { timestamps: true });


const MeetingRoomSchema = new mongoose.Schema({
    name: {
        type: String,
        unique: true,
        required: true
    },
    photo: {
        type: String,
        required: true
    },
    url: {
        type: String,
        required: true
    },
    capacity: {
        type: Number,
        required: true
    },
}, { timestamps: true });


const MeetingBookingModel = mongoose.model('MeetingBooking', MeetingBookingSchema);
const MeetingRoomModel = mongoose.model('MeetingRoom', MeetingRoomSchema);

module.exports = { MeetingBookingModel, MeetingRoomModel };
