const mongoose = require('mongoose');

const userSchema = new mongoose.Schema(
    {
        name:{
          type: String,
          unique: true,
          required: true,
        },
        email: {
          type: String,
          unique: true,
          required: true,
        },
        password: {
          type: String,
          required: false,
        },
        role: {
          type: String,
          enum: ["admin", "user"],
          default: "user",
        },
      },
      { timestamps: true }
)

const UsersModel = mongoose.model('users', userSchema);
module.exports = UsersModel