const express = require('express');
const isAuthenticated = require('../middleware/authenticateToken');
const UsersModel = require('../models/Users');

const router = express.Router();

router.get('/getUserData', isAuthenticated, async (req, res) => {
    try {
        const { email } = req.user;
        const user = await UsersModel.findOne({ email });

        if (!user) {
            return res.status(404).json({ message: 'User not found' });
        }

        res.json({ displayName: user.name, email: user.email, role: user.role });
    } catch (error) {
        res.status(500).json({ error: 'Internal Server Error' });
    }
});

router.get('/getAllUsers', isAuthenticated, async (req, res) => {
    try {
        const users = await UsersModel.find();
        res.json(users);
    } catch (error) {
        res.status(500).json({ error: 'Internal Server Error' });
    }
});

router.get('/getUserCount', isAuthenticated, async (req, res) => {
    try {
        // Menghitung jumlah user dengan role "user"
        const userCount = await UsersModel.countDocuments({ role: 'user' });
        res.json({ userCount });
    } catch (error) {
        res.status(500).json({ error: 'Internal Server Error' });
    }
});

module.exports = router;
