const express = require('express');
const isAuthenticated = require('../middleware/authenticateToken');
const WorkshopModel = require('../models/Workshop');

const router = express.Router();

router.get('/getAllWorkshop', isAuthenticated, async (req, res) => {
    try {
        const workshops = await WorkshopModel.find();
        res.json(workshops);
    } catch (error) {
        res.status(500).json({ error: 'Internal Server Error' });
    }
});

router.post('/createWorkshop', isAuthenticated, async (req, res) => {
    try {
        const { name, capacity } = req.body;
        const workshop = await WorkshopModel.create({ name, capacity });
        res.json(workshop);
    } catch (error) {
        res.status(500).json({ error: 'Internal Server Error' });
    }
})